# include <obdefs.h>
# include <sliders.h>

# define BOXFILL		((IP_6PATT << 4 ) | GREEN )
# define BOXCOLOR		((long)(( GREEN << 12 )|(GREEN << 8) | BOXFILL))
# define BX				0
# define BY				0
# define BW				33
# define BH				19
# define S_HOR			0
# define S_VER			1

# define N_W			5
# define N_X			21

# define Q_W			N_W
# define Q_X			(N_X+N_W+1)
# define TOP			2
# define V_WIDE			2
# define H_HIGH			1
# define T_HIGH			8
# define TONE_MIN		0
# define TONE_MAX		1023		/* ( x 4) would be 4095 with LONG sliders	*/
# define VOL_MIN		0
# define VOL_MAX		15
# define NSE_MIN		0
# define NSE_MAX		31
# define E_P_MIN		0
# define E_P_MAX		4095		/* ( x 16) would be 65535 with LONG sliders	*/
# define E_S_MIN		8
# define E_S_MAX		15

# define CHAN_WIDE		11
# define TONEA			2
# define VOL_A			6
# define TONEB			(CHAN_WIDE+TONEA)
# define VOL_B			(CHAN_WIDE+VOL_A)
# define TONEC			(CHAN_WIDE*2+TONEA)
# define VOL_C			(CHAN_WIDE*2+VOL_A)
# define TGLS_Y			13
# define E_P_Y			15
# define E_P_W			29
# define NSE_Y			17
# define NSE_W			7
# define E_S_X			12
# define E_S_W			7
# define RAX			VOL_A
# define RBX			VOL_B
# define RCX			VOL_C
# define RAY			12
# define GET			-1

int note_op, quit_op;

int n_en_a, n_en_b, n_en_c;
int t_en_a, t_en_b, t_en_c;
int r_e_a, r_e_b, r_e_c;
int r_m_a, r_m_b, r_m_c;
int radio_a, radio_b;radio_c;

struct object *
bld_sliders() {
	
		int box, x;
		static struct object s_tree[ 128 ];
		extern struct slide s_vals[];
		extern int next_item, max_item;
		
		next item = 0;
		box = addit(s_tree,-l,G_BOX,BOXCOLOR,BX,BY,BW,BH);
		s tree[box].ob_state |= OUTLINED | SHADOWED;
		note_op = addit(s_tree,box,G_BUTTON,"NOTE",N.X,NSE_Y,N.W,H_HIGH);
		quit_op = addit(s_tree,box,G_BUTTON,"QUIT",Q_X,NSE_Y,Q_W,H_HIGH);
		s_tree[note_op].ob_flags = TOUCHEXIT | DEFAULT;
		s_tree[quit_op].ob_flags = TOUCHEXIT;
		
		add_slider(s_tree,s_vals,box,S_T_A,TONEA,TOP,V_WIDE,T_HIGH,S_VER,"T");
		add_slider(s_tree,s_vals,box,S_T_B,TONEB,TOP,V_WIDE,T_HIGH,S_VER,"T");
		add_slider(s_tree,s_vals,box,S_T_C,TONEC,TOP,V_WIDE,T_HIGH,S_VER,"T");
		
		add_slider(s_tree,s_vals,box,S_V_A,VOL_A,TOP,V_WIDE,T_HIGH,S_VER,"V");
		add_slider(s_tree,s_vals,box,S_V_B,VOL_B,TOP,V_WIDE,T_HIGH,S_VER,"V");
		add_slider(s_tree,s_vals,box,S_V_C,VOL_C,TOP,V_WIDE,T_HIGH,S_VER,"V");
		
		add_slider(s_tree,s_vals,box,S_N,TONEA,NSE_Y,NSE_W,H_HIGH,S_HOR,"N");
		add_slider(s_tree,s_vals,box,S_S,E_S_X,NSE_Y,E_S_W,H_HIGH,S_HOR,"S");
		add_slider(s_tree,s_vals,box,S_P,TONEA,E_P_Y,E_P_W,H_HIGH,S_HOR,"P");
		
		n_en_a = addit(s_tree,box,G_BUTTON,"n",TONEA,TGLS_Y,1,1);
		n_en_b = addit(s_tree,box,G_BUTTON,"n",TONEB,TGLS_Y,1,1);
		n_en_c = addit(s_tree,box,G_BUTTON,"n",TONEC,TGLS_Y,1,1);
		s_tree[n_en_a].ob_flags |= TOUCHEXIT | SELECTABLE;
		s_tree[n_en_b].ob_flags |= TOUCHEXIT | SELECTABLE;
		s_tree[n_en_c].ob_flags |= TOUCHEXIT | SELECTABLE;
		
		t_en_a = addit(s_tree,box,G_BUTTON,"t",T0NEA+2,TGLS_Y,1,1);
		t_en_b = addit(s_tree,box,G_BUTTON,"t",T0NEB+2,TGLS_Y,1,1);
		t_en_c = addit(s_tree,box,G_BUTTON,"t",T0NEC+2,TGLS_Y,1,1);
		s_tree[t_en_a].ob flags |= TOUCHEXIT | SELECTABLE;
		s_tree[t_en_b].ob_flags |= TOUCHEXIT | SELECTABLE;
		s_tree[t_en_c].ob.flags |= TOUCHEXIT | SELECTABLE;
		
		radio_a = addit(s_tree,box,G_BOX,BOXCOLOR,RAX,RAY,2,2);
		radio_b = addit(s_tree,box,G_B0X,B0XC0L0R,RBX,RAY,2,2);
		radio_c = addit(s_tree,box,G_BOX,BOXCOLOR,RCX,RAY,2,2);
		
		r_e_a = addit(s_tree,radio_a,G.BUTTON,"E",0,0,2,1);
		r_m_a = addit(s_tree,radio_a,G_BUTTON,"M",0,1,2,1);
		s_tree[r_e_a].ob_flags |= TOUCHEXIT | SELECTABLE | RBUTTON;
		s_tree[r_m_a].ob_flags |= TOUCHEXIT | SELECTABLE | RBUTTON;
		
		r_e_b = addit(s_tree,radio_b,G_BUTTQN,"E",0,0,2,1);
		r_m_b = addit(s_tree,radio_b,G_BUTTON,"M",0,1,2,1);
		s_tree[r_e_b].ob_flags |= TOUCHEXIT | SELECTABLE | RBUTTON;
		s_tree[r_m_b].ob_flags |= TOUCHEXIT | SELECTABLE | RBUTTON;
		
		r_e_c = addit(s_tree,radio_c,G_BUTTON,"E",0,0,2,1);
		r_m_c = addit(s_tree,radio_c,G_BUTTON,"M",0,1,2,1);
		s_tree[r_e_c].ob_flags |= TOUCHEXIT | SELECTABLE | RBUTTON;
		s_tree[r_m_c].ob_flags |= TOUCHEXIT | SELECTABLE | RBUTTON;
		
		al1_sliders(s_tree);
		
		s_tree[next_item-1].ob_flags |= LASTOB;
		max_items = next_item;
		return( s tree );
}